//Source file: F:\jschwartz\src\Alkindi\BusinessServices\ISearchManager.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Services;

import Alkindi.Data.SystemUser;
import Alkindi.Data.Product;
import Alkindi.Data.ProductList;
import Alkindi.Data.MovieSearch;
import Alkindi.Data.SystemUserList;
import java.rmi.RemoteException;

/* 
$Header: ISearchManager.java, 9, 12/28/00 2:56:55 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         12/28/00 2:56:55 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 8    Alkindi Development1.7         12/28/00 1:07:08 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:13 PM  Schwartz, Joe   
 6    Alkindi Development1.5         11/20/00 10:52:34 PM Schwartz, Joe   
 5    Alkindi Development1.4         10/19/00 1:12:04 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 4    Alkindi Development1.3         10/9/00 3:12:12 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/6/00 4:13:36 PM   Schwartz, Joe   
 2    Alkindi Development1.1         9/24/00 3:12:15 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:12:05 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This service provides search-related services.
 */
public interface ISearchManager 
{
	
	/**
	 * Locates a given SystemUser given a query string.
	 * @roseuid 399D9AD60157
	 */
	public Alkindi.Data.SystemUserList findMember(java.lang.String query) throws RemoteException,AlkExcept;
	
	/**
	 * Locates a product based on a query string.
	 * @roseuid 39E1FF19003E
	 */
	public Alkindi.Data.ProductList findProduct(final java.lang.String field, final java.lang.String query) throws AlkExcept,RemoteException;
	
	/**
	 * @roseuid 3A18079402FD
	 */
	public Alkindi.Data.ProductList searchMovie(final Alkindi.Data.MovieSearch ms) throws AlkExcept,RemoteException;
}
